using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hive.adkit.daro
{
	public class AdKitBanner
	{
		public AdKitBanner(string adUnitId, BannerPosition position, EventHandlers handler)
		{
			internalInit(adUnitId, position, handler);
		}

		~AdKitBanner(){
			//
		}

		private string adKey = "";

#if UNITY_ANDROID && !UNITY_EDITOR
		
		private string adKitPluginClass = "com.hive.adkit.daro.plugin.AdKitUnityBanner";
		private AndroidJavaObject adKitPlugin = null;

		private void internalInit(string adUnitId, BannerPosition position, EventHandlers handler) {
			AdKitLogger.d("AdKitBanner Init "+adUnitId);

			using (var unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer"))
			using (var currentActivity = unityPlayer.GetStatic<AndroidJavaObject>("currentActivity")) {
				
				adKitPlugin = new AndroidJavaObject(adKitPluginClass);
				if(adKitPlugin != null) {
					adKey = adUnitId;
					adKitPlugin.Call("initialize", currentActivity, adUnitId, (int) position);
					AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);
				} else {
					AdKitLogger.e("Failed to create AndroidJavaObject for " + adKitPluginClass);
				}
			}
		}

		public void Load(string adPlacementInfo) {

			if(adKitPlugin == null) {
				AdKitLogger.e("Load() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}

			AdKitLogger.d("AdKitBanner Load");
			adKitPlugin.Call("load", adPlacementInfo);
		}

		public void Destroy() {

			if(adKitPlugin == null) {
				AdKitLogger.e("Destroy() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}

			AdKitLogger.d("AdKitBanner Destroy");
			adKitPlugin.Call("destroy");
		}

		public bool IsLoaded() {

			if(adKitPlugin == null) {
				AdKitLogger.e("IsLoaded() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return false;
			}

			bool isLoaded = adKitPlugin.Call<bool>("isLoaded");
			return isLoaded;
		}

#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void AdKit_BannerInitialize(string adUnitId, int size);

		[DllImport("__Internal")]
		private static extern void AdKit_BannerLoad(string adUnitId, string adPlacementInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_BannerDestroy(string adUnitId);

		[DllImport("__Internal")]
		private static extern bool AdKit_BannerIsLoaded(string adUnitId);

		private void internalInit(string adUnitId, BannerPosition position, EventHandlers handler) {
			AdKitLogger.d("AdKitBanner Init "+adUnitId);
			adKey = adUnitId;
			
			AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);

			AdKit_BannerInitialize(adUnitId, (int) position);
		}

		public void Load(string adPlacementInfo) {
			AdKitLogger.d("AdKitBanner Load");
			AdKit_BannerLoad(adKey, adPlacementInfo);
		}

		public void Destroy() {
			AdKitLogger.d("AdKitBanner Destroy");
			AdKit_BannerDestroy(adKey);
		}

		public bool IsLoaded() {
			return AdKit_BannerIsLoaded(adKey);
		}
#else

		private void internalInit(string adUnitId, BannerPosition position, EventHandlers handler)
		{

		}

		public void Load(string adPlacementInfo)
		{

		}

		public void Destroy()
		{

		}

		public bool IsLoaded()
		{
			return false;
		}
#endif

	}
}